/******************************************************************************
 * Public header file for LabVIEW_GUI.c
 * 
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2011 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
*******************************************************************************/
#ifndef __LABVIEW_GUI_H__
#define __LABVIEW_GUI_H__


/**************************************************************
* Name: SendDataToLabviewSensorGUI
* Description: This function transfers the payload received
* in the RF frames to the LabVIEW GUI. For more details about
* the content of the frame, see below.
* The 16 bits counter is incremented each time a frame is sent
* through the UART. The purpose of this counter is only to
* keep a count of the frames transferred to the UART. The counter 
* is sent twice because 8 curves are available in the GUI, but the
* user can use less curves (this parameter can be chosen in the 
* LabVIEW settings) or send other data. 
**************************************************************/
void SendDataToLabviewSensorGUI(unsigned char* tmpbuf, uint8_t gau8RxDataBuffer[], uint16_t counter, uint8_t Frame_Verification_Result);

/**************************************************************
* Name: DisplayMessage
* Description: This function displays a message at the bottom
* of the LabVIEW GUI window.
**************************************************************/
void DisplayMessage(uint8_t *ptr_data,uint8_t len);

/**************************************************************
* Name: DisplayMessage
* Description: Pop up message displayed as a pop up with user 
* to be required to press OK
**************************************************************/
void DisplayPopUp(uint8_t *ptr_data,uint8_t len);




/***********************************************************************
* Format of the frames sent to the Freescale LabVIEW Sensor GUI:         
*
* [DA0800011234 Pressure(2 bytes) AccelZ(2 bytes) AccelX(2 bytes) Voltage(1 byte) Temperature(1 byte) StatusAcquisition(1 byte) Counter(2 bytes) ]
* 
* Example: [DA08000112340001010800FDAD5301221DC7]
*
* Important  note: Below is explained how to calculate the actual values of pressure, acceleration, voltage and temperature from the data
* received in the RF frames. But if the Freescale LabVIEW Sensor GUI is used then the user does not need to do the calculation as relevant 
* setting files (.cfg files) are provided with the GUI so that it is directly the actual data that is displayed on the curves (the calculation 
* is done by the GUI).
*
*
* Correspondence between data contained in the frames and actual data (pressure, acceleration, voltage and temperature):

* Pressure:
To know the correspondence between the pressure value given by the module and the actual pressure, c.f to the product specification. An example is given below.
Example:
The example was done with a FXTH870911 device in the range 100  900kPa, using the FXTH870xD datasheet, but it is similar for other ranges of pressure and other families of devices, only sensor characteristics indicated in the datasheet have to be changed accordingly.
Pressure value received: Pressure = 0x0001 = 1 (decimal)
The actual pressure can be calculated with the Eqn. 1 on page 80: P = deltaP900 * PCODE + (100 - deltaP900 )
We have PCODE = 1, it is the value given by the module. Then in the table on page 155 of the datasheet we find that deltaP900 = 1.572 kPa/count.
So we have P = 1.572*1 + (100  1.572) = 100kPa

* AccelZ and AccelX:
To know the correspondence between the acceleration value sent by the module and the actual acceleration, c.f to the product specification.
An example is given below. It was done with a FXTH870911 device, using the FXTH870xD datasheet, but it is similar for the X-axis and other families of devices: only sensor characteristics indicated in the datasheet have to be changed accordingly.
Example:
AccelZ = 0x0108 = 264 (decimal)
- In order to find the actual value of the Z-axis acceleration, we need to know the offset step of the acceleration measure. As the Z-axis acceleration goes from -210g to 300g (FXTH870x11 family) the range has been divided into 16 windows or steps, and each step has been 
divided into 510 counts. So we always get an acceleration value between 1 and 510 counts, but depending on the offset step, that does not correspond to the same actual acceleration. Firmware routines of the TPMS emitter can give the offset step.
In our case the offset step is step 6 so acceleration is between -30g and 30g (information given in the datasheet).
- Then we also need to know some acceleration measurement characteristics of the device that are given in the datasheet (in this example in part 17.10.2 on page 157):
-> Z-axis Average Accel Sensitivity (1 to 510 counts) = 0.118g/count (here we use the average sensitivity but it can be calculated more precisely for each step, c.f. to the datasheet).
-> AZ-6 @ AZCODE1 = -30g
- Now we can apply the Eqn. 17 on page 156 : AZ = deltaAZ6 * AZCODE + (AZ6 @AZCODE1 - deltaAZ6 )
We have deltaAZ6 = 0.118g/count, AZCODE = 264 (the acceleration value given by the module) and AZ6 @AZCODE1 = -30g
So we get AZ = 0.118*264 + (-30  0.118) = 1.034g

* Volt:
To get the value in volt first convert the hexa value in decimal then add 122 and then divide by 100. Example: Volt = 0xAD = 173 (decimal) => V = 2.95V

* Temp:
Temperature is given with an offset of 55. Refer to the product specification.
Example: Temp = 0x53 = 83 (decimal) => T = 83 - 55 = 28C

* Note about StatusAcquisition: Here the status can be set to 1 because the pressure is under 350kPa (measure done at atmospheric pressure). Fore more details refer to the TPMS emitter project source code.

* Frame Verification Result: 
 0x00 => verification ok
 0x11 => checksum verification failed
 0x22 => FXTH CRC verification failed
 0x33 => MKW01 CRC verification failed
 0x44 => no verification selected (selection to be done on the TPMS emitter side)
*************************************************************************/

#endif